/*
        INTRODUCTION D'IMAGES (2) : FICHIER IMAGE
        ACCEDER AUX DATAS DE L'IMAGE :
            - 4 mthodes pour faire une copie d'image
            - pixelisation simple

*/
#define ALLEGRO_STATICLINK
#include "allegro.h"

#define ECRAN_X	1024
#define ECRAN_Y	768
#define MODE    GFX_AUTODETECT

#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("Error : \n%s\n", msg);\
   allegro_exit();\
   return 1;\
}

void tests_copies_bitmap(BITMAP* scr,BITMAP* dest);
void pixeliser(BITMAP*scr, BITMAP* dest,int px,int py);
void remplir(BITMAP*bmp,int x,int y,int px,int py,int color);
/**********************************************************************
**********************************************************************/
int main()
{
PALETTE pal;
BITMAP *im1,*im2;
int tpixx,tpixy;

   allegro_init();
   install_keyboard();
    
   // par dfaut nous sommes en 8 bits pour la couleur
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0)
      ERREUR("set_gfx_mode");
   
   // load de l'image 
   im1=load_bitmap(".\\fleur_8bits.bmp",pal);
   if (!im1 )
      ERREUR("im1");
   
   // activation palette des couleurs de l'image
   set_palette(pal);
   
   // 1 FAIRE UNE COPIE DE BITMAP
   // im1  est la source, im2 la destination
   im2=create_bitmap(im1->w,im1->h);
   if (!im2)
      ERREUR("im2");
   tests_copies_bitmap(im1,im2);
   
   //2 PIXELISATION
   tpixx=1;
   tpixy=2;
   while ( !key[KEY_ESC]){
      
	   // copie im1 dans im2, remise  1 taille pixel (tpixx et tpixy)
      if (key[KEY_ENTER]){
         memcpy(im2->dat,im1->dat,sizeof(unsigned char)*im1->w*im1->h); 
         tpixx=1;
         tpixy=1;
      }
	   //pause
	  if (key[KEY_SPACE])
         while (key[KEY_SPACE]){}
		 
      // jouer sur augmentation taille pixel (avec ou sans hasard)
	  // pour controle de la vitesse mettre action dans le bloc pause
	  tpixx+=rand()%2;
      tpixy+=rand()%2;
      pixeliser(im1,im2,tpixx,tpixy);
	   
      // affichage  l'cran
      textprintf_centre_ex(screen, font, ECRAN_X/2, 10, 255,-1,
      "Press enter pour recopier, espace pour arreter");
      blit(im2,screen,0,0,(ECRAN_X-im2->w)/2,(ECRAN_Y-im2->h)/2,im2->w,im2->h);
   }
   destroy_bitmap(im1);
   destroy_bitmap(im2);
   return 0;
}
END_OF_MAIN();
/******************************************************************************
pour faire une copie de l'image d'origine 5 solutions
 1.  : loader l'image source avec une autre BITMAP*
 2.  : faire une autre bitmap de la mme dimension et blit de l'image  
       source dans l'image destination
 3.  : faire une autre bitmap de la mme dimension et copier  la main 
       les datas
 4.  : avec pointeurs intermdiaires sur les buffers datas des images
 5.  : faire une autre bitmap de la mme dimension et copier les data avec 
       la fonction memcpy in <string.h>
*******************************************************************************/
void tests_copies_bitmap(BITMAP* scr,BITMAP* dest)
{
unsigned char *data1,*data2;
int i,x1,y1;
     
   // test des mthodes de copie 2,3,4,5
   for (i=0; i<4; i++){
      switch (i){
      
         //mthode 2 : blit
         case 0 :
            blit(scr,dest,0,0,0,0,scr->w,scr->h);
            break;
              
         //mthode 3 : copie pixel par pixel
         case 1 :
            for (y1=0; y1<scr->h;y1++)
               for (x1=0; x1<scr->w;x1++)
                  dest->line[y1][x1]=scr->line[y1][x1];
            break;
            
         // mthode 4 : copie pixel par pixel (version 2)
         case 2 :
            data1=(unsigned char*)scr->dat;
            data2=(unsigned char*)dest->dat;
            for (y1=0; y1<scr->w*scr->h; y1++)
               data2[y1]=data1[y1];
            break;
            
         // mthode 5 : copie tout d'un bloc attention taille 8 bits
         case 3 :
            memcpy(dest->dat,scr->dat,sizeof(unsigned char)*scr->w*scr->h); 
            break;
      }
      
      // affichage tmoin :
      // l'image est centre  l'cran
      x1=(ECRAN_X-scr->w)/2;
      y1=(ECRAN_Y-scr->h)/2;
      // pour chacune blit de l'image  l'cran, annonce de la mthode employe
      // et un petit temps pour voir
      blit(dest,screen,0,0,x1,y1,dest->w,dest->h);
      textprintf_centre_ex(screen, font, ECRAN_X/2, 10, 255,-1,
                        "Test automatique de copie d'image (wait and see)");
      textprintf_centre_ex(screen, font, ECRAN_X/2, 20, 255,-1,"Methode %d", i+2);
      rest(3500);
      //ensuite effacer l'cran
      clear_bitmap(screen);
      rest(1000);
   }
}
/**************************************************************************
PIXELISER UNE IMAGE  partir d'une taille en pixel
**************************************************************************/ 
void pixeliser(BITMAP*scr, BITMAP* dest,int px,int py)
{
int x,y,color;
   for (y=0; y+py<scr->h; y+=py)
      for (x=0; x+px<scr->w; x+=px){
         color=scr->line[y][x];
         remplir(dest,x,y,px,py,color);
      }
}
/**************************************************************************
TOOLS de remplissage
**************************************************************************/ 
void remplir(BITMAP*bmp,int x,int y,int px,int py,int color)
{
int x2,y2;
   for (y2=y; y2<y+py; y2++)
      for (x2=x; x2<x+px; x2++)
         bmp->line[y2][x2]=color;
}
/**************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
**************************************************************************/ 

