/*
        INTRODUIRE DES IMAGES (2) : FICHIER IMAGE
        - RECUPERER UN FICHIER IMAGE, SELECTION MODE COULEUR
*/
#include <allegro.h>
#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT_WINDOWED
// une macro pour des contrles d'erreur
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/*******************************************************************************
*******************************************************************************/
int main()
{
char*nom_fichier="image.bmp";
int x,y,colordepth=24; 
BITMAP* image;

   allegro_init();
   install_keyboard();
   
   set_color_depth(colordepth);
   // en 24 bits sous XP et selon carte graphique c'est un mode fentr.
   if (set_gfx_mode(MODE,ECRAN_X,ECRAN_Y,0,0)!=0)
      ERREUR("initialisation mode graphique");
   
   // load image
   image=load_bitmap(nom_fichier,NULL);
   if (!image)
      ERREUR("load mage");
   
   // affichage de l'image centre  l'cran
   x= (SCREEN_W-image->w)/2;
   y= (SCREEN_H-image->h)/2;
   blit(image,screen, 0,0,x,y, image->w,image->h);
   
   // Supprimer l'image de la mmoire 
   destroy_bitmap(image);
   
   // afficher un texte par dessus
   textprintf_ex(screen,font,x+100,y+50,makecol(255,255,255),10,
              "image : %dx%d %ibpp, texte fond opaque",SCREEN_W,SCREEN_H,colordepth);
   
   // afficher un texte par dessus juste les lettres avec fond transaprent
   textprintf_ex(screen,font,x+100,y+100,makecol(0,0,255),-1,
              "Lettres avec fond transparent");
              
   readkey();
   
   return 0;
}
END_OF_MAIN();
/*******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

