/*
		BOUGER UNE FORME - METHODE DU DOUBLE BUFFER A L'ECRAN
*/
#define ALLEGRO_STATICLINK
#include<allegro.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT

#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/******************************************************************************
*******************************************************************************/
int main()
{
int done=0;		// pour fin boucle
// paramtres de la forme
int x,y;		// coordonnes 
int tx,ty;		// taille
int px,py;		// pas d'avancement en x et y
int color;		// couleur
//le buffer image
BITMAP*page;
//pour contrler la vitesse du dplacement
int vmax=5;

   allegro_init();
   install_keyboard();
   srand(time(NULL));

   if (set_gfx_mode(MODE,ECRAN_X,ECRAN_Y,0,0)!=0)
      ERREUR("gfx mode");

   // initialisation des variables de la forme
   tx=rand()%200+20;
   x=rand()%(ECRAN_X-tx*2);
   px=(rand()%vmax)+1;

   ty=rand()%200+20;
   y=rand()%(ECRAN_Y-ty*2);
   py=(rand()%vmax)+1;

   color=makecol(255,0,0);
   
   // creation d'un buffer
   page=create_bitmap(ECRAN_X,ECRAN_Y);
   if (!page)
      ERREUR("creation bitmap");
   clear_bitmap(page);

   // boucle events
   while (!key[KEY_ESC]){
      
      //move
	  x+=px;
	  y+=py;  
	  // contrle orientation : attention vitesse !
	  if (key[KEY_UP])
         py=(--py)%vmax;
	  if (key[KEY_DOWN])
         py=(++py)%vmax;
	  if (key[KEY_LEFT])
         px=(--px)%vmax;
	  if (key[KEY_RIGHT])
		 px=(++px)%vmax;
	  // contrle des bords
	  if (x<0) 
		  px=ABS(px);
	  if (x+tx>ECRAN_X) 
		  px=-ABS(px); 
	  if (y<0)
		  py=ABS(py);
	  if (y+ty>ECRAN_Y)
		  py=-ABS(py);

      // affichage
	  clear_bitmap(page);
	  rectfill(page,x,y,x+tx,y+ty,color);
	  blit(page,screen,0,0,0,0,page->w,page->h);
   }
   exit(EXIT_SUCCESS);
}
END_OF_MAIN();
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/
