/*
    DESSINER, AFFICHER, SAUVER, PHOTO ECRAN
*/
#define ALLEGRO_STATICLINK
#include <allegro.h>
#include <time.h>

#define ECRAN_X	800
#define ECRAN_Y	600

// une macro pour des contrles d'erreur
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
#define TXMAX   100
#define TYMAX   100

void degrade_pas_variable(PALETTE pal);
/******************************************************************************
*******************************************************************************/
int main()
{
BITMAP*bmp,*save;
PALETTE pal;
int x,y,tx,ty,i;
char buf[80];
int cmpt=0;

   allegro_init();
   install_keyboard(); 
   srand(time(NULL));
   
   // par dfaut on est en 8 bits
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
   
   bmp=create_bitmap(SCREEN_W/2,SCREEN_H/2);
   if (! bmp)
      ERREUR("create_bitmap");
   
   // crer une palette de couleurs
   degrade_pas_variable(pal);
   
   // infos menu
   y=10;
   textout_ex(screen,font,"press  :",50,y,255,-1); 
   textout_ex(screen,font,"  D   : dessin",50,y+=10,255,-1);
   textout_ex(screen,font,"  C   : couleur",50,y+=10,255,-1);   
   textout_ex(screen,font,"  S   : save",50,y+=10,255,-1); 
   textout_ex(screen,font,"  E   : photo ecran",50,y+=10,255,-1); 
   textout_ex(screen,font,"  ESC : quitter",50,y+=10,255,-1);   
   
   while (!key[KEY_ESC]){
       
       if (key[KEY_D]){
           // effacement bitmap
          clear_bitmap(bmp); 
          // clear_to_color(bmp, rand()%256);   
          
          for (i=0;i<20;i++){
             x=rand()%(bmp->w-TXMAX);
             tx=rand()%TXMAX;
             y=rand()%(bmp->h-TYMAX);
             ty=rand()%TYMAX;
             rectfill(bmp, x,y,x+tx,y+ty,rand()%256);  
          }
          // position bitmap  l'cran
          x=(SCREEN_W-bmp->w)/2;
          y=(SCREEN_H-bmp->h)/2;
          
          // affichage
          blit(bmp,screen,0,0,x,y,bmp->w,bmp->h);
       }
       
       // changer de palette
       if (key[KEY_C])
          degrade_pas_variable(pal);    
   
       // save bitmap
       if (key[KEY_S]){ 
          cmpt++;
          sprintf(buf,"save%d.bmp",cmpt);
          i=save_bitmap(buf,bmp,pal);
          if (i)
             alert("erreur save",NULL,NULL,"Press enter",NULL,0,0);
          destroy_bitmap(save);
          // bidouille pour attendre touche releve    
          while( key[KEY_S]){} 
       } 
       // capture cran
       if (key[KEY_E]){
          
           save=create_bitmap(SCREEN_W,SCREEN_H);
           blit(screen,save,0,0,0,0,SCREEN_W,SCREEN_H); 
           cmpt++;
           sprintf(buf,"ecran%d.bmp",cmpt);
           i=save_bitmap(buf,save,pal);
           if (i)
             alert("erreur photo ecran",NULL,NULL,"Press enter",NULL,0,0);
           destroy_bitmap(save);
           while( key[KEY_E]){} 
       }    
   }
   destroy_bitmap(bmp);
   exit(EXIT_SUCCESS);
}
END_OF_MAIN();
/******************************************************************************
Crer une palette
*******************************************************************************/
void degrade_pas_variable(PALETTE pal)
{
int i,rouge,pr,vert,pv,bleu,pb;

	pal[0].r=pal[0].g=pal[0].b=0;
	rouge = rand()%54+5;
	pr = rand()%11-5;
	vert = rand()%54+5;
	pv = rand()%11-5;
	bleu = rand()%54+5;
	pb = rand()%11-5;
	for(i=1;i<256;i++){
		rouge += pr;
		pal[i].r = rouge;
		if( rouge <=ABS(pr) || rouge >= 63-ABS(pr))
			pr*=-1;
		vert += pv;
		if( vert <=ABS(pv) || vert >= 63-ABS(pv))
			pv*=-1;
		pal[i].g = vert;
		bleu +=pb;
		if( bleu <=ABS(pb) || bleu >= 63-ABS(pb))
			pb*=-1;
		pal[i].b = bleu;
	}
	set_palette(pal);
}
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

