/*
        INTRODUCTION D'IMAGES
        DESSINER DANS UNE BITMAP EN MEMOIRE 
*/
#define ALLEGRO_STATICLINK
#include <allegro.h>
#include <time.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("Error : \n%s\n", msg);\
   allegro_exit();\
   return 1;\
}
void degrade_pas_variable(PALETTE pal);
void attendre(int tmp);
/******************************************************************************
L'affichage se fait avec un double buffer afin d'avoir une bonne qualit 
d'animation
*******************************************************************************/
int main()
{
PALETTE pal;					  
BITMAP*bmp;
int x,y,r;

   allegro_init();
   install_keyboard(); 
        
   if (set_gfx_mode(GFX_AUTODETECT_WINDOWED, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR("gfx_mode");
   
   // la bitmap et le buffer
   bmp=create_bitmap(61,100);
   if (!bmp)
      ERREUR("create_bitmap bmp");
      
   // une palette
   degrade_pas_variable(pal);
   
   // DESSIN dans la bitmap
   clear_bitmap(bmp);
   // oeil gauche
   x=60/4;
   y=100/4;
   r=5;
   circle(bmp,x-r*2,y,r,100);
   circle(bmp,x-r*2,y,r-3,200);
   // oeil droit
   x=(60/4)*3;
   y=100/4;
   r=5;
   circle(bmp,x+r*2,y,r,100);
   circle(bmp,x+r*2,y,r-3,200);
   // nez
   triangle(bmp, 0, 99, 59, 99, 30, 0, 50);
   // dents
   for (x=0, y=89,r=0; x<60; x+=4,r^=1){
      if (r)
         rectfill(bmp, x,y,x+4,y+10,0);
      else
         rectfill(bmp, x,y,x+4,y+10,255);
   }
   
   // position du sprite dessin
   x=(ECRAN_X-bmp->w)/2;
   y=(ECRAN_Y-bmp->h)/2;
   r=0;
   
   // affichage  l'cran
   blit(bmp,screen,0,0,x,y,ECRAN_X,ECRAN_Y);
   
   // BOUCLE EVENT
   while (!key[KEY_ESC]){
      
      // un temps d'attente  
      attendre(70);
      // une nouvelle palette tous les pas de 4
      if (!(++r%4))
        degrade_pas_variable(pal);
   }
   destroy_bitmap(bmp);
   exit(EXIT_SUCCESS);
}
END_OF_MAIN();
/*****************************************************************************
quivalent aux fonctions rest(long t) ou delay(long t)
*****************************************************************************/
void attendre(int tmp)
{
time_t t0=clock(); // pour dpart

   while (clock()<t0+tmp){} 
}
/******************************************************************************
Crer une palette
*******************************************************************************/
void degrade_pas_variable(PALETTE pal)
{
int i,rouge,pr,vert,pv,bleu,pb;

	pal[0].r=pal[0].g=pal[0].b=0;
	rouge = rand()%54+5;
	pr = rand()%11-5;
	vert = rand()%54+5;
	pv = rand()%11-5;
	bleu = rand()%54+5;
	pb = rand()%11-5;
	for(i=1;i<256;i++){
		rouge += pr;
		pal[i].r = rouge;
		if( rouge <=ABS(pr) || rouge >= 63-ABS(pr))
			pr*=-1;
		vert += pv;
		if( vert <=ABS(pv) || vert >= 63-ABS(pv))
			pv*=-1;
		pal[i].g = vert;
		bleu +=pb;
		if( bleu <=ABS(pb) || bleu >= 63-ABS(pb))
			pb*=-1;
		pal[i].b = bleu;
	}
	set_palette(pal);
}
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

