/*
        DETECTION DE COLLISIONS - COLLISION SIMPLE
        - Deux rectangles
*/

#define ALLEGRO_STATICLINK
#include <allegro.h>
#include <string.h>
#include <stdio.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT_WINDOWED

#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("Error : \n%s\n", msg);\
   allegro_exit();\
   return 1;\
}
// pour informations des deux rectangles
typedef struct FORME{
	int x,y;		//position
	int tx,ty;		//taille
	int couleur;    //couleur
}FORME;
/******************************************************************************
*******************************************************************************/
int main()
{
PALETTE pal;					  
BITMAP*page;
FORME f1,f2;
int color;

   allegro_init();
   install_keyboard(); 
   install_mouse();
   srand(time(NULL));
     
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR("gfx_mode");
   
   // buffer
   page=create_bitmap(ECRAN_X,ECRAN_Y);
   if (!page)
      ERREUR("create_bitmap page");
   
   // forme fixe
   f2.tx=rand()%200+100;
   f2.ty=rand()%200+100;
   f2.x=(ECRAN_X-f2.tx)/2;
   f2.y=(ECRAN_Y-f2.ty)/2;
   //forme mobile
   f1.tx=40;
   f1.ty=40;
   // boucle event
   while (!key[KEY_ESC]){
      
      if (f1.x!=mouse_x || f1.y!=mouse_y){
         f1.x=mouse_x;
         f1.y=mouse_y;
         
         clear_bitmap(page);
         if (collision_rect(&f1, &f2))
            color=makecol(0,255,0);
         else
            color=makecol(0,0,255);
         
         rect(page,f2.x,f2.y,f2.x+f2.tx,f2.y+f2.ty,makecol(255,0,0));
         rect(page,f1.x,f1.y,f1.x+f1.tx,f1.y+f1.ty,color);
         
         blit(page,screen,0,0,0,0,page->w,page->h);
      }
   }
   // sortie
   destroy_bitmap(page);
   return 0;
}
END_OF_MAIN();
/*****************************************************************
Collision de deux rectangles
*****************************************************************/
int collision_rect(FORME *f1, FORME *f2)
{
int res=1;

   if ( (f1->x > f2->x + f2->tx -1) ||   // f1  droite de f2
        (f1->y > f2->y + f2->ty -1) ||   // f1 en dessous
        (f2->x > f1->x + f1->tx -1) ||   // f2  droite de f1
        (f2->y > f1->y + f1->ty -1)   ){ // f2 en dessous

	     res=0;	 // pas de collision
   }
   return res;
}
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/
