/*
        ANIMATION A PARTIR DE SPRITE - CONTROLE DU MOUVEMENT
        UN CHAT TRAVERSE L'ECRAN
*/

#include <allegro.h>
#include <time.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT_WINDOWED
// une macro pour des contrles d'erreur
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/******************************************************************************
*******************************************************************************/
int main()
{
char buf[80];
BITMAP *page,*im[6];
int i,x,y,courant,tmps,maxtmps;

   allegro_init();
   install_keyboard(); 
   
   set_color_depth(16);
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
   
   page =create_bitmap(SCREEN_W,SCREEN_H);
   if (!page)
      ERREUR("creation buffer page");
      
   for (i=0;i<6;i++){
      sprintf(buf,"cat%d.bmp",i+1);  
      im[i]=load_bitmap(buf,NULL);
      if(!im[i])
         ERREUR("load image");   
   }
   // variables animation
   courant=0;
   tmps=0;  
   maxtmps=5;
   //position de dpart  gauche pas de mouvement verticaux
   x=0;
   y=(ECRAN_Y/8)*3;
   while (!key[KEY_ESC]){
   
      clear_bitmap(page);
      x+=5;
      x=(x > SCREEN_W-im[courant]->w) ? 0 : x;
      
      if (tmps++>maxtmps){
         tmps=0;
         courant=(++courant)%6; 
      }
      // affichage
      draw_sprite(page,im[courant],x,y);
      // affichage infos
      textprintf_ex(page,font,10,10,makecol(255,255,255),-1,
      "x = %d, y = %d",x,y);
      textprintf_ex(page,font,10,30,makecol(0,255,0),-1,
      "image = %d, attente = %d, attente max = %d",courant,tmps,maxtmps);
      
      blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
      
       rest(20); 
   }
   destroy_bitmap(page);
   for(i=0;i<6;i++)
      destroy_bitmap(im[i]);
      
   return 0;
   
}
END_OF_MAIN();
/******************************************************************************
*******************************************************************************/



/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

