/*
        ANIMATION A PARTIR DE SPRITES - DEPLACEMENT DE PERSONNAGES AU CLAVIER
        PERSONNAGE TYPE ZELDA
*/

#include <allegro.h>
#include <string.h>

#define ECRAN_X	640
#define ECRAN_Y	480
#define MODE    GFX_AUTODETECT_WINDOWED
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/******************************************************************************
*******************************************************************************/
int main()
{
char buf[80];
BITMAP *im[8],*page;
int i,done,x,y,haut,bas,gauche,droite;

   allegro_init();
   install_keyboard(); 
   
   set_color_depth(16);
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
      
   // charger les huits images du sprite
   for (i=0;i<8;i++){
       sprintf(buf,"z%d.bmp",i);
       im[i]=load_bitmap(buf,NULL);
       if (!im[i])
          ERREUR("load image");
   }
   // double buffer
   page=create_bitmap(SCREEN_W,SCREEN_H);
   if (!page)
      ERREUR("creation buffer");
      
   // position de dpart
   done=haut=bas=gauche=droite=0;
   x=SCREEN_W/2; 
   y=SCREEN_H/2;  
   
   while (!done){
      textprintf_ex(screen, font, 10,10, makecol(255,255,255),-1,
      "press fleches haut,bas,gauche, droite et esc pour quitter");
      clear_bitmap(page);
      switch( readkey()>>8){
             
          case KEY_UP : // O, 1 le bonhomme monte
              if (y>0)
                 y--;
              draw_sprite(page,im[0+haut],x,y);
              haut^=1; // met  0 ce qui est identique et  1 ce qui diffre
              break;
                
          case KEY_DOWN : // 2, 3 il descend
              if (y+im[2+bas]->h<SCREEN_H)
                 y++;
              draw_sprite(page,im[2+bas],x,y);
              bas^=1;
              break;
            
          case KEY_LEFT : // 4, 5 il va  gauche
              if (x>0)
                 x--;
              draw_sprite(page,im[4+gauche],x,y);
              gauche^=1;
              break;
                 
          case KEY_RIGHT : // 6,7 va  droite
              if (x+im[6+droite]->h<SCREEN_W)
                 x++;
              draw_sprite(page,im[6+droite],x,y);
              droite^=1;
              break;
              
          default : 
              done=1 ; 
              break;
      }
      blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
   }
   
   destroy_bitmap(page);
   for (i=0;i<8;i++)
       destroy_bitmap(im[i]);
         
   exit(EXIT_SUCCESS); 
}
END_OF_MAIN();
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

