/*
        MANIPULER DES SPRITES - ROTATIONS AUTOUR D'UN PIVOT QUELCONQUE
*/

#include <allegro.h>
#include <time.h>

#define ECRAN_X	800
#define ECRAN_Y	600

#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("Error : \n%s\n", msg);\
   allegro_exit();\
   return 1;\
}
#define BLANC   makecol(255,255,255)
#define ROUGE   makecol(255,128,64)
/******************************************************************************
*******************************************************************************/
int main()
{
BITMAP *tank;
BITMAP *page;
float angle=0;
int x,y,pivx,pivy;

   allegro_init();
   install_keyboard(); 
   
     set_color_depth(16);  
   if (set_gfx_mode(GFX_AUTODETECT, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
   
   // load image
   tank=load_bitmap("tank.bmp",NULL);
   page=create_bitmap(SCREEN_W,SCREEN_H);
   if (!tank||!page)
      ERREUR("load image");
      
   // initialisation dpart :
   // l'image au centre tourne autour de son propre centre
   x=SCREEN_W/2;
   y=SCREEN_H/2;
   pivx=tank->w/2;
   pivy=tank->h/2;
   
   while (!key[KEY_ESC]){
      rest(10);
      // dplacer le pivot 
      if (keypressed()){
         // ici le pivot est li  la taille de l'image sprite mais il peut en 
         // sortir et tre au del
         if (key[KEY_LEFT]){
            pivx-=2;
            pivx=(pivx<0)?0:pivx;
         }
         if (key[KEY_RIGHT]){
            pivx+=2;
            pivx=(pivx>tank->w-1)?tank->w-1:pivx;
         }
         if (key[KEY_UP]){
            pivy-=2;
            pivy=(pivy<0)?0:pivy;
         }
         if (key[KEY_DOWN]){
            pivy+=2;
            pivy=(pivy>tank->h-1)?tank->h-1:pivy;
         }
      }
      // l'angle volue de faon constante par pas de 0,5
      angle+=0.5;
      angle=(angle>256)?0:angle;
      // affichage
      clear_bitmap(page);
      pivot_sprite(page,tank,x,y,pivx,pivy,ftofix(angle));
      hline(page,x-50,y,x+50,ROUGE);
      vline(page,x,y-50,y+50,ROUGE);
      //infos
      textprintf_ex(page,font,0,10,BLANC,-1,
      "Changer le pivot pivot : fleches gauche, droite, haut, bas");
      textprintf_ex(page,font,0,20,BLANC,-1,"Pivot = %d, %d",pivx,pivy);
      textprintf_ex(page,font,0,30,BLANC,-1,"x = %d, y = %d",x,y);
   
      blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
      
   }
   return 0;
   
}
END_OF_MAIN();
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

