/*
        NOTION DE MASQUE, DEPLACER UNE IMAGE SUR UNE IMAGE
        Fonction masked_blit() (et masked_stretch_blit())

*/

#include <allegro.h>

#define ECRAN_X	800
#define ECRAN_Y	600
#define MODE    GFX_AUTODETECT_WINDOWED

// une macro pour des contrles d'erreur
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/******************************************************************************
*******************************************************************************/
int main()
{
BITMAP *image,*masque,*page;
PALETTE pal;
int x,y,ox,oy;

   allegro_init();
   install_keyboard(); 
   install_mouse();
   
   // travail en 8 bits avce palette
   if (set_gfx_mode(MODE, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
   
   //2 images et le double buffer
   masque=load_bitmap("gargouille.bmp",pal);
   image=load_bitmap("eau.bmp",pal);
   page=create_bitmap(SCREEN_W,SCREEN_H);
   if (!image||!masque||!page)
      ERREUR("load image");
   
   // palette correspondant  la deuxime image
   set_palette(pal);
   
   ox=oy=0;
   while (!key[KEY_ESC]){
      
      x=mouse_x;
      y=mouse_y;
      // affichage si mouvement souris uniquement
      if (ox!=x ||oy!=y){
         // l'image construite dans le double buffer
         blit(image,page,0,0,0,0,SCREEN_W,SCREEN_H);
         masked_blit(masque,page,0,0,x-SCREEN_W/2,y-SCREEN_H/2,SCREEN_W,SCREEN_H);  
         // affichage cran
         blit(page,screen,0,0,0,0,SCREEN_W,SCREEN_H);
         // position actuelle conserve
         ox=x;
         oy=y;  
      }    
   }
   // 
   destroy_bitmap(image);
   destroy_bitmap(masque);
   destroy_bitmap(page);

   return 0;
}
END_OF_MAIN();
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

