/*
        BOUGER DES FORMES AVEC DES IMAGES - L'IMAGE A TRAVERS UNE FORME
*/

#include <allegro.h>
#include <time.h>

#define ECRAN_X	800
#define ECRAN_Y	600

// une macro pour des contrles d'erreur
#define ERREUR(msg) {\
   set_gfx_mode(GFX_TEXT,0,0,0,0);\
   allegro_message("erreur ligne %d, fichier %s: %s\n",__LINE__, __FILE__,msg);\
   allegro_exit();\
   exit(EXIT_FAILURE);\
}
/******************************************************************************
*******************************************************************************/
int main()
{
BITMAP *pat,*page;
int x,y,px,py;

   allegro_init();
   install_keyboard(); 
   srand(time(NULL));
   
   set_color_depth(16);
   if (set_gfx_mode(GFX_AUTODETECT, ECRAN_X, ECRAN_Y, 0, 0) != 0) 
      ERREUR(allegro_error);
   
   page=create_bitmap(SCREEN_W,SCREEN_H);
   pat=load_bitmap("pat1.bmp",NULL);
   if (!pat||!page)
      ERREUR("load image");
   
   x=rand()%(SCREEN_W-60);
   y=rand()%(SCREEN_H-100);
   px=rand()%11-5;
   py=rand()%11-5;
   
   drawing_mode(DRAW_MODE_COPY_PATTERN, pat, 0, 0);
		
   while (!key[KEY_ESC]){
      clear(page);
      rectfill(page,x,y,x+60,y+100,0);
      
      if (key[KEY_LEFT])
         px--;
      if (key[KEY_RIGHT])
         px++;
      if (key[KEY_UP])
         py--;
      if (key[KEY_DOWN])
         py++;
      x+=px;
      y+=py;
      
      px=(x<0)? ABS(px):(x>SCREEN_W-60)? -ABS(px) : px;
      py=(y<0)? ABS(py):(y>SCREEN_H-100)? -ABS(py) : py;
      
      blit(page,screen,0,0,0,0,page->w,page->h);
      
      rest(30);
      
   }
   destroy_bitmap(pat);
   destroy_bitmap(page);
   return 0;
   
}
END_OF_MAIN();
/******************************************************************************
RAPPEL LINKAGE lib static :
pour dev :
dans menu : Projet/otpions du projet/paramtres/diteur de liens , l, 
copier la liste suivante :
  -lalleg_s -lgdi32 -lwinmm -lole32 -ldxguid -ldinput -lddraw -ldsound
et dans la colonne "compilateur"  gauche de l'diteur de liens copier
  -DALLEGRO_STATICLINK
cliquer "OK"
*******************************************************************************/

